/*
 * Line randomizer
 *
 * Copyright 1996, Brad Grantham.  All Rights Reserved.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#define MAX_LINES 1000
char	lines[MAX_LINES][160];
int	used[MAX_LINES];
int	linecnt;


int main()
{
	int	i;
	int	l;

	linecnt = 0;

	while((linecnt < MAX_LINES) && (gets(lines[linecnt]) != NULL))
		used[linecnt] = 0, linecnt++;

	if(linecnt == MAX_LINES)
		fprintf(stderr, "Warning: line buffer filled.  May have
			lost data\n");

	for(i = 0; i < linecnt; i++){
		l = random() % linecnt;
		while(used[l]){
			l = (l + 1) % linecnt;
		}
		used[l] = 1;
		printf("%s\n", lines[l]);
	}
	return(0);
}
